IF EXISTS(SELECT * FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO_EXECUTE_ALL]')
          AND type IN(N'P', N'PC'))
    DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO_EXECUTE_ALL];
GO
GO
CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO_EXECUTE_ALL]
                 @CD_EMP   INT      = 1
               , @QT_MESES INT      = 1
               , @DT_INI   DATETIME = NULL
AS
     IF @DT_INI IS NULL
         BEGIN
             SET @DT_INI = DBO.F_ONTEM();
         END;
     DECLARE @CD_DEPOSITO INT;
     PRINT 'Processamento do analise diaria para todas as filiais ';
     DECLARE depositos CURSOR FAST_FORWARD
     FOR SELECT
                CD_CTR_DEPO
         FROM
              PRC_FILIAL_DEPOSITO
			  where flag_desativado=0;
     OPEN depositos;
     FETCH NEXT FROM depositos INTO @CD_DEPOSITO;
     WHILE @@FETCH_STATUS = 0
         BEGIN
             PRINT '  Analise deposito '+CONVERT(VARCHAR(5), @CD_DEPOSITO)+' ('+CONVERT(VARCHAR(8), GETDATE(), 114)+')...';
             EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO
                     @CD_EMP
                   , @QT_MESES
                   , @DT_INI
                   , @CD_DEPOSITO;
             FETCH NEXT FROM depositos INTO @CD_DEPOSITO;
         END;
     PRINT 'Concludo.';
     CLOSE depositos;
     DEALLOCATE depositos;